from sklearn.model_selection import RandomizedSearchCV, KFold
from sklearn.naive_bayes import BernoulliNB
from sklearn.metrics import accuracy_score, make_scorer
from pathlib import Path

def write_hpValues(model_Name, HP_Values,dataset):
    Path("results/%s" % dataset).mkdir(parents=True, exist_ok=True)
    Path("results/%s/%s" % (dataset,model_Name)).mkdir(parents=True, exist_ok=True)
    file_name = r'results/%s/%s/BestParam.txt' % (dataset,model_Name)
    with open(file_name, 'a+') as x_file:
        x_file.write(str(HP_Values))
        x_file.write("\n----------------------------------------------------------")
    return 0


# parameters grid to select the best combination using the listed values
def BernoulliNB_hyperparameterTuning(X_train, Y_train, dataset):
    B_NB = BernoulliNB()
    B_NB.fit(X_train, Y_train)
    HP_Values = 'NON'
    write_hpValues("BernoulliNB", HP_Values, dataset)
    return B_NB


def BernoulliNB_training_tuning(X_train,Y_train, dataset):

    BNB_Trained = BernoulliNB_hyperparameterTuning(X_train,Y_train, dataset)
    BNB_Trained.fit(X_train,Y_train)
    return BNB_Trained
